TITLE   'Metal and Dielectric Objects in (r,z)'    		{ exa115.pde }
SELECT     						{ Professional Edition }
   errlim=1e-7     ngrid=1     spectral_colors	
COORDINATES   ycylinder('r','z')	
VARIABLES   U
DEFINITIONS						
   r0=0.04     d0=0.05     Lr=2.0     Lz=1.0	
   eps0=8.854e-12     epsr     eps=epsr*eps0
   Ez0=1e5     Dz0=eps0*Ez0      			{ Far Field }        	
   Er= -dr(U)     Ez= -dz(U)     E= -grad(U)     Em=magnitude(E)
   D= eps*E     Dm=magnitude(D)
   F1=surf_integral( -0.5*normal(D)*Ez, 'ball') 	{ Force on metal }
   fs=0.5*(eps-eps0)*[normal(E)^2*epsr+tangential(E)^2]	{ Dielectric }
   unit_z=vector(0,1)					{ Direction of z }
   f=fs*normal( unit_z)				{ Force/area, z-component }
   F2=surf_integral( f, 'ellipsoid')			{ Force on dielectric }
EQUATIONS
   div( D)=0	         				
BOUNDARIES
region 'domain'   epsr=1        			{ Vacuum outside }
   start(0,-Lz)  natural(U)= -Dz0  line to (Lr,-Lz)
   natural(U)=0 line to (Lr,Lz)
   natural(U)=Dz0  line to (0,Lz)
   natural(U)=0  line to (0,d0+r0) value(U)=0
   arc( center=0,d0) angle= -180 to (0,d0-r0)	{ Metal ball }
   natural(U)=0 line to close
region 'glass'  epsr=7.0				
   start 'ellipsoid' (0,-d0-r0)				
   arc( center=0,-d0) to (2*r0,-d0) to (0,-d0+r0) line to close
feature
   start 'ball' (0,d0+r0) arc( center=0,d0) angle=-180 to (0,d0-r0)
PLOTS
   vector( D) norm     contour( Dm) painted zoom(0,-2.5*d0,  5*d0,5*d0)
   vector( D) norm zoom(0,-2.5*d0,  5*d0,5*d0)
      report( F1) as 'F1 on metal'   report( F2)   report((F1+F2)/F1)
END

